---
generated_at: 2026-02-10 15:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：98-C# REPL (csi)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Interactive/csi/Csi.cs`
- E-02: `src/Scripting/Core/Hosting/CommandLine/CommandLineRunner.cs`
- E-03: `src/Scripting/CSharp/Hosting/CSharpInteractiveCompiler.cs`
- E-04: 機能一覧.csv（No.98 C# REPL (csi)）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Csi.Main エントリーポイント | E-01: 18-51行目 | ○ |
| C-02 | InteractiveResponseFileName = "csi.rsp" | E-01: 16行目 | ○ |
| C-03 | csi ディレクトリ取得 | E-01: 24行目 GetTypeInfo().Assembly | ○ |
| C-04 | BuildPaths 構築 | E-01: 26-30行目 | ○ |
| C-05 | CSharpInteractiveCompiler 作成 | E-01: 32-36行目 | ○ |
| C-06 | CommandLineRunner 作成 | E-01: 38-42行目 | ○ |
| C-07 | runner.RunInteractive() 呼び出し | E-01: 44行目 | ○ |
| C-08 | NotImplementedAnalyzerLoader 使用 | E-01: 36行目 | ○ |
| C-09 | CSharpScriptCompiler.Instance 使用 | E-01: 41行目 | ○ |
| C-10 | CSharpObjectFormatter.Instance 使用 | E-01: 42行目 | ○ |
| C-11 | RunInteractive メソッド | E-02: 53-69行目 | ○ |
| C-12 | RunInteractiveCore メソッド | E-02: 74-148行目 | ○ |
| C-13 | RunScript メソッド | E-02: 200-220行目 | ○ |
| C-14 | RunInteractiveLoop メソッド | E-02: 222-292行目 | ○ |
| C-15 | #help コマンド対応 | E-02: 274-278行目 IsHelpCommand | ○ |
| C-16 | MaxDisplayCount = 5 | E-02: 378行目 | ○ |
| C-17 | IsCompleteSubmission チェック | E-02: 258-262行目 | ○ |
| C-18 | パフォーマンス要件（1秒、500ms） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件**：ソースコードに具体的なパフォーマンス目標は定義されていない。
  - 候補：プロジェクト要件定義書 / ベンチマークテスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - エントリーポイントの説明（ソースコード確認済み）
- 0: 低リスク - REPL ループの説明
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] Csi.Main の処理フローが正確か
- [ ] CommandLineRunner の REPL 動作が正しく説明されているか
- [ ] csi.rsp の役割が正確に説明されているか
- [ ] コードリーディングガイドの行番号が最新コードと一致しているか
